$(document).ready(async function () {
  componenteFiltro('deposito', false, false, 'DepositoGerarOrdemCompra')
  componenteFiltro('moeda', false, false, 'MoedaGerarOrdemCompra')

  $('#formGerarOrdemCompra').validate({
    rules: {
      entrega: {
        required: true,
      },
      deposito: {
        required: true,
      },
    },
    messages: {
      entrega: 'Data de entrega é obrigatória.',
      deposito: 'Depósito é obrigatório.',
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
    }
  })

  const resetForm = (formSelector) => {
    $(formSelector)[0].reset()
    const validator = $(formSelector).validate()
    validator.resetForm()
    $(formSelector)
      .find('.error')
      .removeClass('error')
  }

  $('#modalGerarOrdemCompra').on('hide.bs.modal', () => {
    limparModal()
    resetForm('#formGerarOrdemCompra')
  })

  const limparModal = () => $('.formGerarOrdemCompra').val('')

  $('#btnConfirmarGerarOrdemCompra').on('click', async () => {
    const formValido = $('#formGerarOrdemCompra').valid()
    if (!formValido) {
      return
    }

    let dados = null

    await new Promise((resolve) => {
      msgAlerta(
        'Deseja efetivar a ordem de compra?',
        () => null,
        () => {
          dados = ModalGerarOrdemCompra.retornarDadosGravar({ efetivar: false })
          resolve()
        },
        () => {
          dados = ModalGerarOrdemCompra.retornarDadosGravar({ efetivar: true })
          resolve()
        },
        () => null,
        true,
      )
    })

    if (!dados) {
      return
    }
    $.LoadingOverlay('show')
    ModalGerarOrdemCompra.gravar({ ...dados, efetivar: false })
      .finally(() => $.LoadingOverlay('hide'))
  })
})

window.ModalGerarOrdemCompra = window.ModalGerarOrdemCompra || {}

ModalGerarOrdemCompra.itens = null
ModalGerarOrdemCompra.fornecedor = null

ModalGerarOrdemCompra.abrir = function () {
  $('#modalGerarOrdemCompra').modal('show')
}

ModalGerarOrdemCompra.fechar = function () {
  $('#modalGerarOrdemCompra').modal('hide')
}

ModalGerarOrdemCompra.gravar = async function (dados) {
  try {
    const response = await requisicao('POST', `/sisplan/analise_cotacao/v1/ordemcompra?`, '', JSON.stringify(dados), 3600000)
    const json = await response.json()

    if (json) {
      const { mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }
    }

    toastr.success("Dados gravados com sucesso!", "Confirmação", {
      toastClass: "alert",
      iconClasses: {
        error: "alert-error",
        info: "alert-info",
        success: "alert-success",
        warning: "alert-warning",
      },
      positionClass: "toast-top-center",
      progressBar: true,
      timeOut: 1000,
      fadeOut: 1000,
      onHidden() {
        ModalGerarOrdemCompra.fechar()
      },
    }).css({
      "margin-top": "20%",
      width: "500px",
      "max-width": "500px",
    })
  } catch (error) {
    console.error(error)
    msgErro(error)
  }
}

ModalGerarOrdemCompra.validarDados = function (dados) {
  if (dados?.itens?.length === 0) {
    msgErro('Nenhuma cotação selecionada, impossível continuar.')
    return false
  }

  const primeiraCotacao = dados?.itens[0]?.numero

  if (dados?.itens?.some((item) => item.numero !== primeiraCotacao)) {
    msgErro('Não é permitido gerar uma ordem de compra para cotações diferentes.')
    return false
  }

  if (dados?.itens?.some((item) => item.preco === 0)) {
    msgErro('Existem itens selecionados com preço zerado, impossível continuar.')
    return false
  }

  return true
}

ModalGerarOrdemCompra.retornarDadosGravar = function ({ efetivar }) {
  try {
    const dataEntrega = $('#txtEntregaGerarOrdemCompra').val() || '1899-12-31'
    const deposito = pegaChave('#txtDepositoGerarOrdemCompra')
    const moeda = pegaChave('#txtMoedaGerarOrdemCompra') || '0'
    const itens = ModalGerarOrdemCompra.itens?.map(
      (item, index) => ({
        ...item,
        deposito,
        ordem: index + 1,
        status_compra: efetivar ? 'B' : 'D'
      })
    )

    const ordemCompra = {
      empresa: getCookie('empresa'),
      dt_emissao: retornarDataISOEmYMD({ separadorData: '-', usarUTC: true }),
      usuario: getCookie('usuario'),
      codfor: ModalGerarOrdemCompra.fornecedor,
      dt_entrega: dataEntrega,
      deposito,
      moeda,
      itens,
    }

    return {
      ordemCompra,
    }
  } catch (error) {
    console.error('Ocorreu um erro ao retornar os dados.')
    return null
  }
}

ModalGerarOrdemCompra.carregar = function (dados) {
  ModalGerarOrdemCompra.itens = dados.itens
  ModalGerarOrdemCompra.fornecedor = dados.fornecedor
  $('#txtEntregaGerarOrdemCompra').val(dados.entrega)
  insereValor('#txtMoedaGerarOrdemCompra', dados.moeda.codigo, dados.moeda.descricao)
}