<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Cadastro de Região de Estado</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.2510.9.1">
    <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2510.9.1">
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.2510.9.1" />
    <link href='../dist/css/bootstrap.min.css?versao=3.2510.9.1'>
    <link rel="stylesheet" href="../dist/css/custom.css?versao=3.2510.9.1">
    <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.2510.9.1">
    <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2510.9.1">
    <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.2510.9.1">
    <link rel="shortcut icon" href="../favicon.ico">
    <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.2510.9.1">
    <link rel="stylesheet" href="../plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2510.9.1">

    <!-- Toastr -->
    <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.2510.9.1">
    <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.2510.9.1" />
    <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.2510.9.1">
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <style>
        #progressbar li {
            list-style-type: none;
            font-size: 12px;
            width: 100%;
            float: left;
            position: relative
        }

        .labelCheck {
            font-size: 110%;
            padding: 0.2%;
            margin-left: 1%;
        }

        .configCheck {
            -ms-transform: scale(1.5);
            -moz-transform: scale(1.5);
            -webkit-transform: scale(1.5);
            -o-transform: scale(1.5);
            transform: scale(1.5);
            padding: 10px;
        }

        .radiosStyle {
            font-size: 120%;
            margin-top: 1%;
            margin-bottom: 1%;
        }

        .checkboxMoeda {
            border: solid #e0e4e6;
            border-radius: 4px;
            border-width: 2px;
        }

        .bordaTab {
            border: solid #e0e4e6;
            border-radius: 4px;
            border-width: 2px;
            margin-top: 9.6%;
        }

        .configTabPreco {
            -ms-transform: scale(1.5);
            -moz-transform: scale(1.5);
            -webkit-transform: scale(1.5);
            -o-transform: scale(1.5);
            transform: scale(1.5);
        }

        .border-Field .textoBorda {
            font-size: 1.1em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1px solid var(--font-color) !important;
            padding: 0 1.0em 0 1.0em !important;
            margin: 0 0 0 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
            border-radius: 3px !important;
        }

        .icheck-primary {
            margin-top: 0px !important;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <div class="content-wrapper">
            <section class="content">
                <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                            <div class="col-sm-6 flex">
                            </div>
                            <div class="col-sm-6">
                                <!-- <ol class="breadcrumb float-sm-right">
                  
                  <li class="breadcrumb-item"><a href="../cstipi">Acesso CST IPI</a></li>
                  <li class="breadcrumb-item active">Cadastro de CST IPI</li>
                </ol> -->
                            </div><!-- /.col -->
                        </div>
                    </div>
                    <div class="row justify-content-center mt-0">
                        <div class="col-10 text-center p-0 mt-3 mb-2">
                            <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                                    <h2>Cadastro de Região de Estado
                                        <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                            <i class="fas fa-question-circle"></i>
                                        </button>
                                    </h2>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mx-0 mb-3">
                                        <form id="msform">
                                            <ul id="progressbar">
                                                <li class="active" id="account"><strong>Geral</strong></li>
                                            </ul>
                                            <p>Preencha os dados e clique em gravar para realizar o cadastro ou alteração de Região de Estado.</p>
                                            <fieldset class="row justify-content-center mt-5">
                                                <div class="row col-10 justify-content-md-start justify-content-center" id="campostudo">
                                                    <div class="row col-3 mb-3 mr-1 mt-3 mt-md-0 text-left" id="tutorialTipo">
                                                        <fieldset class="form border-Field mb-0 pb-0 d-flex col-sm-12 col-md-12 col-12">
                                                            <legend class="textoBorda mb-0 pb-0">Tipo</legend>
                                                            <div class="icheck-primary mr-3"><input type="radio" checked id="radioComercial" name="tipo"><label for="radioComercial">Comercial</label></div>
                                                            <div class="icheck-primary mr-3"><input type="radio" id="radioLogistica" name="tipo"><label for="radioLogistica">Logística</label></div>
                                                        </fieldset>
                                                    </div>
                                                    <div id="tutorialRegiaoCota" class="col-2 row pt-4">
                                                        <label data-error="wrong" class="pr-2" data-success="right" for="cbRegiaoCota">Região de Cota </label>
                                                        <div class="icheck-primary"><input type="checkbox" id="cbRegiaoCota" data-placement="top"><label for="cbRegiaoCota" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas as facções selecionados na pesquisa, se desmarcado, desconsidera as facções selecionados na pesquisa e filtra por todos as outras facções."></label>
                                                        </div>
                                                    </div>
                                                    <div class="row col-12">
                                                        <div class="col-sm-2 col-md-2 col-2 pl-0 form-group text-left" id="tutorialCodigo">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código: *</label>
                                                            <div class="input-group">
                                                                <input maxlength="2" type="text" class="input-default focus form-control validate" required aria-describedby="codigoError" id="txtCodigo" name="txtCodigo" class="form-control" placeholder="Código">
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-2 col-md-2 col-2 form-group text-left" id="tutorialCodigo2">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo2">Código 2: </label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control validate" required aria-describedby="codigoError" id="txtCodigo2" name="txtCodigo2" class="form-control" placeholder="Código 2">
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-8 col-md-8 col-8 form-group text-left" id="tutorialDescricao">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtDescricao">Descrição: *</label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control" required aria-describedby="produtoError" id="txtDescricao" name="txtDescricao" class="form-control" placeholder="Descrição">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row col-12 mt-1" id="tutorialObs">
                                                        <div class="col-sm-12 col-md-12 col-12 text-left pl-0">
                                                            <label data-error="wrong" data-success="right" for="txtObs">Obs: </label>
                                                            <input type="text" autocomplete="off" class="input-default focus form-control" id="txtObs" name="txtObs" class="form-control" placeholder="Observação">
                                                        </div>
                                                    </div>
                                            </fieldset>
                                            <div class="ml-3 d-flex justify-content-end">
                                                <button type="button" id="btnVoltar" style="font-size:15px;" class="btn btn-secondary btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                                                <button type="button" name="btnGravar" id="btnGravar" class="btn btn-danger btn-sisp mr-1 action-button">Gravar</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <?php
    include_once('../../../modais.php');
    ?>

    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    </div>

    <script src="../plugins/jquery/jquery.min.js?versao=3.2510.9.1"></script>
    <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.2510.9.1"></script>
    <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.2510.9.1"></script>
    <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.2510.9.1"></script>
    <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.2510.9.1"></script>
    <script src="../plugins/toastr/toastr.min.js?versao=3.2510.9.1"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2510.9.1"></script>
    <script src="../dist/js/adminlte.min.js?versao=3.2510.9.1"></script>
    <script src="../dist/js/requisicoes.js?versao=3.2510.9.1"></script>
    <script src="../dist/js/cliente/entidade.js?versao=3.2510.9.1"></script>
    <script src="../dist/js/loadingoverlay.min.js?versao=3.2510.9.1"></script>
    <script src="../dist/js/valida_cpf_cnpj.js?versao=3.2510.9.1"></script>
    <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.2510.9.1"></script>
    <script src="../dist/js/sisplan.js?versao=3.2510.9.1"></script>
    <script src="../utils/funcoes.js?versao=3.2510.9.1"></script>
    <script src="../dist/js/driver.min.js?versao=3.2510.9.1"></script>
    <script src="../dist/js/jquery.maskMoney.min.js?versao=3.2510.9.1"></script>
    <script src="../utils/cookies.js?versao=3.2510.9.1"></script>
    <script src="../dist/js/dataTables.keyTable2.js?versao=3.2510.9.1"></script>
    <script type="text/javascript" src="../config.js?versao=3.2510.9.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('CADREGESTADO');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            const permissaoUsuarioLogado = await permissaoAcessos("CADREGESTADO");

            if (permissaoUsuarioLogado.INCLUI == 'N') {
                await criaMensagemErro("Sem permissão para incluir!", () => {
                    window.location.href = `${BASE_URI}/cadregestado`
                });
                return;
            }

            const queryString = window.location.href;
            const parametros = queryString.split("/");
            const cadregestado = parametros[parametros.length - 1];

            $(window).on("beforeunload", function(e) {
                // e.preventDefault()
                e.stopPropagation();
                deletaRegistro("CADREGESTADO", getCookie("usuario"), cadregestado);
                return undefined;
            });

            sArquivo = `${BASE_URI}/pages/cadregestado/cadastro_cadregestado/cadregestado.js?versao=3.2510.9.1`;
            insereJavaScriptPagina(sArquivo);

            const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
            habilitaCamposObrigatoriosTela(nomeTela);
        });
    </script>
</body>

</html>