<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Radar NFe</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2510.9.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2510.9.1">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>


  <link rel="stylesheet" href="dist/css/custom.css?versao=3.2510.9.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2510.9.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2510.9.1" />
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2510.9.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2510.9.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2510.9.1">
  <style>
    .border-Field {
      border: 1px groove #ddd !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }

    .border-Field .textoBorda {
      font-size: 1.2em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .quadrado {
      width: 25px;
      margin-right: 5px;
      height: 25px;
    }

    #legendas {
      flex-direction: row;
      flex-wrap: wrap;
    }

    #tabelaNFe {
      overflow: hidden;
      white-space: nowrap;
    }




    .btn-close-feedback {
      height: 25px;
      width: 25px;
      margin-left: 10px;
      align-self: flex-center;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .icone {
      width: 20px;
      height: 20px;
      display: inline-block;
    }

    .texto {
      /* display: none; */
      margin-left: 0px;
      overflow: hidden;
      white-space: nowrap;
      display: inline-block;
      width: 0%;
      max-width: 0;
    }

    #show-content:hover .icone {
      opacity: 0;
    }

    #show-content:hover .texto {
      -webkit-transition: width 0.5s linear;
      -moz-transition: width 0.5s linear;
      -o-transition: width 0.5s linear;
      transition: width 0.5s linear;
      max-width: 100%;
      width: 100%;
      margin-left: 5px;
    }

    .buttonCard img {
      height: 35px;
      width: 35px;
    }

    div.driver-popover-item {
      position: absolute;
      background: #fff;
      /* color: #2d2d2d; */
      margin: 0;
      padding: 15px;
      border-radius: 5px;
      min-width: 1000px;
      max-width: 1000;
      box-shadow: 0 1px 10px rgba(0, 0, 0, .4);
      z-index: 1000000000
    }

    div.driver-popover-item .driver-popover-tip {
      border: 5px solid #fff;
      content: "";
      position: absolute
    }

    div.driver-popover-item .driver-popover-tip.bottom {
      bottom: -10px;
      border-color: #fff transparent transparent
    }

    div.driver-popover-item .driver-popover-tip.bottom.position-center {
      left: 49%
    }

    div.driver-popover-item .driver-popover-tip.bottom.position-right {
      right: 20px
    }

    div.driver-popover-item .driver-popover-tip.left {
      left: -10px;
      top: 10px;
      border-color: transparent #fff transparent transparent
    }

    div.driver-popover-item .driver-popover-tip.left.position-center {
      top: 46%
    }

    div.driver-popover-item .driver-popover-tip.left.position-bottom {
      top: auto;
      bottom: 20px
    }

    div.driver-popover-item .driver-popover-tip.right {
      right: -10px;
      top: 10px;
      border-color: transparent transparent transparent #fff
    }

    div.driver-popover-item .driver-popover-tip.right.position-center {
      top: 46%
    }

    div.driver-popover-item .driver-popover-tip.right.position-bottom {
      top: auto;
      bottom: 20px
    }

    div.driver-popover-item .driver-popover-tip.top {
      top: -10px;
      border-color: transparent transparent #fff
    }

    div.driver-popover-item .driver-popover-tip.top.position-center {
      left: 49%
    }

    div.driver-popover-item .driver-popover-tip.top.position-right {
      right: 20px
    }

    div.driver-popover-item .driver-popover-tip.mid-center {
      display: none
    }

    div.driver-popover-item .driver-popover-footer {
      display: block;
      margin-top: 10px
    }

    div.driver-popover-item .driver-popover-footer button {
      background-color: rgba(253, 253, 253, 0.877);
      width: 65px;
      height: 35px;
      border-radius: 5px;
      border: 0.5px #e6e6e68a;
      user-select: none;
      display: flex;
      justify-content: center;
      align-items: center;
      font-size: 13px;
      margin: 2px;
    }

    div.driver-popover-item .driver-popover-footer button.driver-disabled {
      color: grey;
      background-color: rgb(216, 216, 216);
      cursor: default;
      pointer-events: none
    }

    div.driver-popover-item .driver-popover-footer .driver-close-btn {
      float: left;
      color: white;
      background-color: rgb(199, 72, 72);
    }

    div.driver-popover-item .driver-popover-footer .driver-close-btn:hover {
      transition: 0.6s;
      background-color: rgb(175, 50, 50);
      color: white;
    }

    div.driver-popover-item .driver-popover-footer .driver-next-btn {
      color: white;
      background-color: rgb(53, 53, 223);
    }

    div.driver-popover-item .driver-popover-footer .driver-next-btn:hover {
      transition: 0.6s;
      background-color: rgb(23, 23, 206);
      color: white;
    }

    div.driver-popover-item .driver-popover-footer .driver-prev-btn {
      color: white;
      background-color: rgb(50, 53, 231);
    }

    div.driver-popover-item .driver-popover-footer .driver-prev-btn:hover {
      transition: 0.6s;
      background-color: rgb(23, 23, 206);
      color: white;
    }

    div.driver-popover-item .driver-popover-footer .driver-btn-group,
    div.driver-popover-item .driver-popover-footer .driver-close-only-btn {
      float: right
    }

    div.driver-popover-item .driver-popover-title {
      font: 19px/normal sans-serif;
      margin: 0 0 5px;
      font-weight: 700;
      display: block;
      position: relative;
      line-height: 1.5;
      zoom: 1
    }

    div.driver-popover-item .driver-popover-description {
      margin-bottom: 0;
      font: 14px/normal sans-serif;
      line-height: 1.5;
      color: #2d2d2d;
      font-weight: 400;
      zoom: 1
    }

    .driver-clearfix:after,
    .driver-clearfix:before {
      content: "";
      display: table
    }

    .driver-clearfix:after {
      clear: both
    }

    .driver-stage-no-animation {
      transition: none !important;
      background: transparent !important;
      outline: 5000px solid rgba(0, 0, 0, .75)
    }

    div#driver-page-overlay {
      background: #000;
      position: fixed;
      top: 0;
      left: 0;
      bottom: 0;
      right: 0;
      display: block;
      width: 100%;
      height: 100%;
      zoom: 1;
      filter: alpha(opacity=75);
      opacity: .75;
      z-index: 100002 !important;
      transition: all .3s
    }

    div#driver-highlighted-element-stage {
      position: absolute;
      top: 0;
      left: 0;
      height: 50px;
      width: 1000;
      background: #fff;
      z-index: 100003 !important;
      display: none;
      border-radius: 2px;
      transition: all .3s
    }

    .driver-highlighted-element {
      z-index: 100004 !important
    }

    .driver-position-relative {
      position: relative !important
    }

    .driver-fix-stacking {
      z-index: auto !important;
      opacity: 1 !important;
      transform: none !important;
      -webkit-filter: none !important;
      filter: none !important;
      perspective: none !important;
      transform-style: flat !important;
      transform-box: border-box !important;
      will-change: unset !important
    }

    .sidebar-collapse .driver-popover-item {
      display: none;
      background-color: #242b2c;
      z-index: 1000000000;
      transform: translateX(350px) !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Radar NFe</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
          </div>
          <div class="card">
            <div class="card-body">
              <div class="flex">
                <div class="d-flex col-4 px-0" style="flex-direction: column; gap: 10px" id="buttonsFiltros">
                  <button class="btn btn-success btn-sisp btn-lg" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
                  <button class="btn btn-success btn-sisp btn-lg" id="btnAtualizarListaNFe" style="max-height: 50%!important;"><i class="fas fa-sync-alt"></i> Atualizar Lista de NFe</button>
                </div>

                <div class="col-8 ml-2" id="tipos">
                  <div class="d-flex justify-content-center" id="legendas">
                    <div style="margin: 10px 10px 0px 0px" class="d-flex align-items-center">
                      <div class="quadrado" style="background: #6495ED;">
                      </div>
                      <span> Existe Manifestação </span>
                    </div>
                    <div style="margin: 10px 10px 0px 0px" class="d-flex align-items-center">
                      <div class="quadrado" style="background: #FF0000;">
                      </div>
                      <span> Cancelada </span>
                    </div>
                    <div style="margin: 10px 10px 0px 0px" class="d-flex align-items-center">
                      <div class="quadrado" style="background: #3CB371;">
                      </div>
                      <span> NF Entrada </span>
                    </div>
                    <div style="margin: 10px 10px 0px 0px" class="d-flex align-items-center">
                      <div class="quadrado" style="background: var(--linhaAmarela);">
                      </div>
                      <span> Sem Nota De Entrada </span>
                    </div>
                    <div style="margin: 10px 10px 0px 0px" class="d-flex align-items-center">
                      <div class="quadrado" style="background: #006400;">
                      </div>
                      <span> Nota Referenciada </span>
                    </div>
                    <div style="margin: 10px 10px 0px 0px" class="d-flex align-items-center">
                      <div class="quadrado" style="background: #BC8F8F;">
                      </div>
                      <span> Op. Não Realizada / Desconhecimento da Op </span>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-sm-12 table-responsive" id="tabelaTour">
                <table id="tabelaNFe" class="table table-sm table-select table-hover" width="100%">
                  <thead>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>

              <div class="flex mt-2">
                <div class="col-5 pr-0">
                  <label>Tipo de Manifestação da NFe</label>
                  <div class="flex justify-content-between">
                    <div class="col-7 px-0">
                      <select class="drilldown-item form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="tipoManifestacao" style="height: 48px !important;">
                        <option class="drilldown-item" value="Nenhuma">Nenhuma</option>
                        <option class="drilldown-item" value="ConfirmaOperacao">Confirmação da Operação</option>
                        <option class="drilldown-item" value="DesconhecimentoOperacao">Desconhecimento da Operação</option>
                        <option class="drilldown-item" value="OperacaoNaoRealizada">Operação não realizada</option>
                        <option class="drilldown-item" value="CienciaOperacao">Ciencia da Operação</option>
                      </select>
                    </div>
                    <button class="btn btn-success btn-sisp btn-lg mr-auto" id="btnConfirmarManifestacao"> Confirmar Manifestação</button>
                  </div>
                </div>
                <div class="col-7 pt-4 mt-1"> 
                  <div class="flex justify-content-end" style="gap: 12px">
                    <div class="d-flex" style="flex-direction: column;" title='O botão "Visualizar Danfe" gera uma pré-visualização utilizando o relatório DANFE'>
                      <button class="btn btn-success btn-sisp btn-lg" id="btnVisualizarDanfe"><span class="fas fa-file"></span> Visualizar Danfe</button>
                    </div>
                    <div class="d-flex" style="flex-direction: column;">
                      <button class="btn btn-success btn-sisp btn-lg" id="btnEntradaNF"><span class="fas fa-file"></span> Entrada NF</button>
                    </div>
                    <div class="d-flex" style="flex-direction: column;" id="buttonsFiltros">
                      <button class="btn btn-success btn-sisp btn-lg" id="btnDownloadXml"><span class="fas fa-download"></span> Download XML</button>
                    </div>
                    <div class="d-flex" style="flex-direction: column;">
                      <button class="btn btn-success btn-sisp btn-lg" id="btnExcluirXML"><span class="fas fa-trash"></span> Excluir XML</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modal-justificativa">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title" id="title-justificativa">Justificativa da Manifestação</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row block">
            <div class="col-sm-12">
              <div class="group-default form-group">
                <label data-error="wrong" data-success="right" for="txtJustificativa">Justificativa</label>
                <input class="d-none" id="txt_cancelar_cupom" />
                <textarea type="textarea" style="resize: none" placeholder="Justificativa" class="input-default focus form-control validate" id="txtJustificativa" name="txtJustificativa" required="required" rows="3"></textarea>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn bg-gradient-danger btn-sisp" data-dismiss="modal">Fechar</button>
          <button id="btnConfirmaJustificativa" type="button" class="btn bg-gradient-success btn-sisp">Confirmar</button>
        </div>
      </div>
    </div>
  </div>

  <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" role="document">
      <div class="modal-content" id="modalBody">
        <div class="modal-header">
          <h4 class="modal-title">Filtros</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-5">

              <div class="row">

                <div class="form-group group-default col-md-6 col-6">
                  <label>Data de Emissão de:</label>
                  <div class="relative" id="DataEmissao">
                    <input type="date" class="input-default focus form-control validatel" id="txtDtEmissaoI">
                  </div>
                </div>
                <div class="form-group group-default col-md-6 col-6">
                  <label>Data de Emissão até:</label>
                  <div class="relative" id="DataEmissao">
                    <input type="date" class="input-default focus form-control validatel" id="txtDtEmissaoF">
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="form-group col-12 col-md-12" id="FornecInfoTour">
                  <label data-error="wrong" data-success="right" for="txtFornecedor">Fornecedor
                    *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control validate" required="required" id="txtFornecedor" name="txtFornecedor" class="form-control" placeholder="Fornecedor">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Fornecedor" name="btn-Fornecedor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Fornecedor" name="btn-limpa-Fornecedor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="row">
                <div class="form-group group-default col-md-6 col-6">
                  <label for="txtNumeroNFe">Numero NFe</label>
                  <div class="relative">
                    <input type="text" class="input-default focus form-control validate" id="txtNumeroNFe" placeholder="Numero NFe">
                  </div>
                </div>
                <div class="form-group group-default col-md-6 col-6">
                  <label for="txtSerieNFe">Série NFe</label>
                  <div class="relative">
                    <input type="text" class="input-default focus form-control validate" id="txtSerieNFe" placeholder="Série NFe">
                  </div>
                </div>
              </div>

              <div class="row">
                <div class="form-group group-default col-md-12 col-12">
                  <label for="txtBuscaNSUMaior">Busca NSU Maior que:</label>
                  <div class="relative">
                    <input type="text" class="input-default focus form-control validate" id="txtBuscaNSUMaior" placeholder="Busca NSU">
                  </div>
                </div>
              </div>
            </div>

            <div class="col-7">
              <div class="row" style="gap: 5px">
                <div class="col-6">
                  <fieldset class="border-Field px-3">
                    <legend class="textoBorda">Tipo de Manifestação da NFe</legend>
                    <div class="d-flex" id="tipoManifestacao">
                      <div class="">
                        <div class="form-group">
                          <div class="icheck-primary">
                            <input type="radio" id="radioTodas" value="0" name="tp_manifestacao" checked>
                            <label for="radioTodas">Todas
                            </label>
                          </div>
                          <div class="icheck-primary">
                            <input type="radio" id="radioNenhuma" value="1" name="tp_manifestacao">
                            <label for="radioNenhuma">Nenhuma
                            </label>
                          </div>
                          <div class="icheck-primary">
                            <input type="radio" id="radioConfOp" value="2" name="tp_manifestacao">
                            <label for="radioConfOp">Confirmação da Operação</label>
                          </div>
                          <div class="icheck-primary">
                            <input type="radio" id="radioDescOp" value="3" name="tp_manifestacao">
                            <label for="radioDescOp">Desconhecimento da Operação
                            </label>
                          </div>
                          <div class="icheck-primary">
                            <input type="radio" id="radioOpNaoRealizada" value="4" name="tp_manifestacao">
                            <label for="radioOpNaoRealizada">Operação não Realizada
                            </label>
                          </div>
                          <div class="icheck-primary">
                            <input type="radio" id="radioCienciaOp" value="5" name="tp_manifestacao">
                            <label for="radioCienciaOp">Ciência da Operação
                            </label>
                          </div>
                        </div>
                      </div>
                    </div>
                  </fieldset>
                </div>
                <div class="col-4">
                  <fieldset class="border-Field px-3">
                    <legend class="textoBorda">Arquivo XML</legend>
                    <div class="d-flex" id="arquivoXML">
                      <div class="">
                        <div class="form-group">
                          <div class="icheck-primary">
                            <input type="radio" id="radioTdsArq" value="0" name="arq_xml" checked>
                            <label for="radioTdsArq">Todos
                            </label>
                          </div>
                          <div class="icheck-primary">
                            <input type="radio" id="radioComXml" value="1" name="arq_xml">
                            <label for="radioComXml">Com XML
                            </label>
                          </div>
                          <div class="icheck-primary">
                            <input type="radio" id="radioSemXml" value="2" name="arq_xml">
                            <label for="radioSemXml">Sem XML</label>
                          </div>
                        </div>
                      </div>
                    </div>
                  </fieldset>
                </div>
                <div class="col-6">
                  <fieldset class="border-Field px-3">
                    <legend class="textoBorda">Lançamento Compras</legend>
                    <div class="d-flex" id="lancaCompra">
                      <div class="form-group">
                        <div class="icheck-primary">
                          <input type="radio" id="radioTdsLanc" value="0" name="lanc_compras" checked>
                          <label for="radioTdsLanc">Todos
                          </label>
                        </div>
                        <div class="icheck-primary">
                          <input type="radio" id="radioSimLanc" value="1" name="lanc_compras">
                          <label for="radioSimLanc">Sim
                          </label>
                        </div>
                        <div class="icheck-primary">
                          <input type="radio" id="radioNaoLanc" value="2" name="lanc_compras">
                          <label for="radioNaoLanc">Não</label>
                        </div>
                      </div>
                    </div>
                  </fieldset>
                </div>
                <div class="col-4 d-none">
                  <fieldset class="border-Field">
                    <legend class="textoBorda">Exibir Eventos NFe</legend>
                    <div class="d-flex" id="exibirEventosNFe">
                      <div class="form-group clearfix">
                        <div class="icheck-primary">
                          <input type="radio" id="radioTdsEventos" value="0" name="exibir_eventos" checked>
                          <label for="radioTdsEventos">Todos
                          </label>
                        </div>
                        <div class="icheck-primary">
                          <input type="radio" id="radioNfePos" value="1" name="exibir_eventos">
                          <label for="radioNfePos">NF-e Posicionada
                          </label>
                        </div>
                        <div class="icheck-primary">
                          <input type="radio" id="radioNaoEventos" value="2" name="exibir_eventos">
                          <label for="radioNaoEventos">Não</label>
                        </div>
                      </div>
                    </div>
                  </fieldset>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
            <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php
  include_once('../../modais.php');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  <script src="plugins/jquery/jquery.min.js?versao=3.2510.9.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2510.9.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2510.9.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2510.9.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2510.9.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.2510.9.1"></script>
  <script src="dist/js/sisplan.js?versao=3.2510.9.1"></script>
  <script src="utils/funcoes.js?versao=3.2510.9.1"></script>
  <script src="utils/cookies.js?versao=3.2510.9.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.2510.9.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.2510.9.1"></script>
  <script src="dist/js/driver.min.js?versao=3.2510.9.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.2510.9.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.2510.9.1"></script>
  <script type="text/javascript" src="config.js?versao=3.2510.9.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RADARNFE');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/radarnfe/radarnfe.js?versao=3.2510.9.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>