<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Relatório de Pendente de Terceiros</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2510.9.1">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2510.9.1">
    <!-- Google Font: Source Sans Pro -->
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2510.9.1" />
    <link href='dist/css/bootstrap.min.css?versao=3.2510.9.1'>
    <link rel="stylesheet" href="dist/css/custom.css?versao=3.2510.9.1">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2510.9.1">
    <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2510.9.1">
    <link rel="stylesheet" type="text/css" href="dist/css/responsive.bootstrap.min.css?versao=3.2510.9.1">
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.2510.9.1">
    <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2510.9.1">
    <link rel="stylesheet" href="dist/css/select.bootstrap.min.css?versao=3.2510.9.1" />
    <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.2510.9.1">
    <!-- Toastr -->
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2510.9.1">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2510.9.1" />
    <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2510.9.1">
    <link rel="stylesheet" href="dist/css/cadastro.css?versao=3.2510.9.1">
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <style>
        .bordaCampos {
            border: solid #e0e4e6;
            border-radius: 4px;
            border-width: 2px;
            padding-top: 2%;
            padding-bottom: 0%;
        }

        .bordaCampos:first-child {
            display: flex;
            flex-direction: row;
            flex-wrap: wrap;
            justify-content: flex-end;
            align-items: center;
        }

        .border-Field .textoBorda {
            font-size: 1.0em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1.0px solid var(--font-color) !important;
            padding: 0 1.0em 1.0em 1.0em !important;
            margin: 0 0 1.0em 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
            padding-bottom: 0px !important;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <main class="wrapper">

        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6 flex">
                            <h1 class="m-0 text-dark">Relatório de Pendente de Terceiros</h1>
                            <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                <i class="fas fa-question-circle"></i></button>
                        </div>
                        <div class="col-sm-6">

                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <fieldset>
                                <div class="row">
                                    <div class="col-12">
                                        <div class="buttons">
                                            <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-filter"></span> Filtros</button>
                                            <button id="btnImprimir" class="btn-sisp btn btn-danger"><i class="fas fa-print"></i> Imprimir</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="card">
                                        <div class="row">
                                            <div class="col-sm-6 d-flex justify-content-center align-items-center" style="height: 100%;">
                                                <div id="graficoRelPendente" style="width: 100%;"></div>
                                            </div>
                                            <div class="col-sm-6 d-flex justify-content-center align-items-center" style="height: 100%;">
                                                <div id="graficoRelPendente1" style="width: 100%;"></div>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 table-responsive card-body">
                                            <table id="tabelaRelPendente" class="table table-sm table-select table-hover" style="white-space: nowrap;" width="100%"></table>
                                            <thead>
                                                <tr></tr>
                                            </thead>
                                            <tbody>
                                                <tr></tr>
                                            </tbody>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-6 d-none" id="containerSubProduto">
                                            <div class="card" id="cardSubProduto">
                                                <div class="col-sm-12 table-responsive card-body">
                                                    <table id="tabelaRelPendenteSubProduto" class="table table-sm table-select table-hover" style="white-space: nowrap;" width="100%"></table>
                                                    <thead>
                                                        <tr></tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr></tr>
                                                    </tbody>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12" id="containerPedido">
                                            <div class="card" id="cardPedido">
                                                <div class="col-sm-12 table-responsive card-body">
                                                    <table id="tabelaRelPendentePedido" class="table table-sm table-select table-hover" style="white-space: nowrap;" width="100%"></table>
                                                    <thead>
                                                        <tr></tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr></tr>
                                                    </tbody>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content" id="modalBody">
                    <div class="modal-header">
                        <h4 class="modal-title">Filtros
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body py-1 px-0">
                        <div class="card-body pt-0 pb-0">
                            <div class="row">
                                <div class="col-12">
                                    <div class="row mt-2">
                                        <div class="row col-12">
                                            <div class="col-xl-2 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="dtPrevRetornoDe">Prev. Retorno De: </label>
                                                <div class="relative">
                                                    <div class="input-group px-0 col-12">
                                                        <input type="date" max="2500-12-31" class="input-default focus form-control" value="1200-01-01" id="dtPrevRetornoDe" name="dtPrevRetornoDe" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-2 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="dtPrevRetornoAte">Até: </label>
                                                <div class="relative">
                                                    <div class="input-group px-0 col-12">
                                                        <input type="date" max="2500-12-31" class="input-default focus form-control" value="2500-12-31" id="dtPrevRetornoAte" name="dtPrevRetornoAte" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-2 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="dtFinalDe">Final De: </label>
                                                <div class="relative">
                                                    <div class="input-group px-0 col-12">
                                                        <input type="date" max="2500-12-31" class="input-default focus form-control" value="1200-01-01" id="dtFinalDe" name="dtFinalDe" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-2 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="dtFinalAte">Até: </label>
                                                <div class="relative">
                                                    <div class="input-group px-0 col-12">
                                                        <input type="date" max="2500-12-31" class="input-default focus form-control" value="2500-12-31" id="dtFinalAte" name="dtFinalAte" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-2 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="dtEnvioDe">Envio De: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="date" max="2500-12-31" class="input-default focus form-control" value="1200-01-01" id="dtEnvioDe" name="dtEnvioDe" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-2 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="dtEnvioAte">Até: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="date" max="2500-12-31" class="input-default focus form-control" value="2500-12-31" id="dtEnvioAte" name="dtEnvioAte" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-xl-4 col-12 form-group">
                                                <div class="icheck-primary d-flex"><input type="checkbox" value="S" class="checkfiltros" id="cbConsideraFaccao" data-placement="top" checked><label for="cbConsideraFaccao" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas as facções selecionados na pesquisa, se desmarcado, desconsidera as facções selecionados na pesquisa e filtra por todos as outras facções."></label>
                                                    <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtFaccao">Facção: </label>
                                                </div>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtFaccao" name="txtFaccao" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-FaccaoConsulta" name="btn-FaccaoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Faccao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <div class="icheck-primary d-flex"><input type="checkbox" value="S" class="checkfiltros" id="cbConsideraSetor" data-placement="top" checked><label for="cbConsideraSetor" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas os setores selecionados na pesquisa, se desmarcado, desconsidera os setores selecionados na pesquisa e filtra por todos os outros setores."></label>
                                                    <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtSetor">Setor:</label>
                                                </div>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtSetor" name="txtSetor" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-SetorConsulta" name="btn-SetorConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Setor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <div class="icheck-primary d-flex"><input type="checkbox" value="S" class="checkfiltros" id="cbConsideraMarca" data-placement="top" checked><label for="cbConsideraMarca" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas as marcas selecionados na pesquisa, se desmarcado, desconsidera as marcas selecionados na pesquisa e filtra por todos as outras marcas."></label>
                                                    <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtMarca">Marca:</label>
                                                </div>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtMarca" name="txtMarca" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-MarcaConsulta" name="btn-MarcaConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Marca" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtProduto">Produto: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtProduto" name="txtProduto" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-ProdutoConsulta" name="btn-ProdutoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Produto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <div class="icheck-primary d-flex"><input type="checkbox" value="S" class="checkfiltros" id="cbConsideraColecao" data-placement="top" checked><label for="cbConsideraColecao" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas as coleções selecionados na pesquisa, se desmarcado, desconsidera as coleções selecionados na pesquisa e filtra por todos as outras coleções."></label>
                                                    <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtColecao">Coleção: </label>
                                                </div>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtColecao" name="txtColecao" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-ColecaoConsulta" name="btn-ColecaoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Colecao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <div class="icheck-primary d-flex"><input type="checkbox" value="S" class="checkfiltros" id="cbConsideraLinha" data-placement="top" checked><label for="cbConsideraLinha" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas as linhas selecionados na pesquisa, se desmarcado, desconsidera as linhas selecionados na pesquisa e filtra por todos as outras linhas."></label>
                                                    <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtLinha">Linha: </label>
                                                </div>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtLinha" name="txtLinha" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-LinhaConsulta" name="btn-LinhaConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Linha" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtOf">OF: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtOf" name="txtOf" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-OfConsulta" name="btn-OfConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Of" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtGrupoCli">Grupo Cli.: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtGrupoCli" name="txtGrupoCli" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-GrupoCliConsulta" name="btn-GrupoCliConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-GrupoCli" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtCliente">Cliente: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtCliente" name="txtCliente" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-ClienteConsulta" name="btn-ClienteConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtPedido">Pedido: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtPedido" name="txtPedido" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-PedidoConsulta" name="btn-PedidoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Pedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtDeposito">Depósito: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtDeposito" name="txtDeposito" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-DepositoConsulta" name="btn-DepositoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Deposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtFluxo">Fluxo: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtFluxo" name="txtFluxo" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-FluxoConsulta" name="btn-FluxoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Fluxo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtRepresentante">Representante: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtRepresentante" name="txtRepresentante" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-RepresentanteConsulta" name="btn-RepresentanteConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Representante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtStatusPed">Status Ped.: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtStatusPed" name="txtStatusPed" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-StatusPedConsulta" name="btn-StatusPedConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-StatusPed" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtFaixa">Faixa: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtFaixa" name="txtFaixa" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-FaixaConsulta" name="btn-FaixaConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Faixa" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtCor">Cor: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtCor" name="txtCor" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-CorConsulta" name="btn-CorConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Cor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtTamanho">Tamanho: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtTamanho" name="txtTamanho" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-TamanhoConsulta" name="btn-TamanhoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Tamanho" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <div class="icheck-primary d-flex"><input type="checkbox" value="S" class="checkfiltros" id="cbConsideraGrupoProd" data-placement="top" checked><label for="cbConsideraGrupoProd" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas os grupos selecionados na pesquisa, se desmarcado, desconsidera os grupos selecionados na pesquisa e filtra por todos os outros grupos."></label>
                                                    <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtGrupoProd">Grupo Prod.: </label>
                                                </div>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtGrupoProd" name="txtGrupoProd" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-GrupoProdConsulta" name="btn-GrupoProdConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-GrupoProd" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-xl-4 col-12 form-group">
                                                <div class="icheck-primary d-flex"><input type="checkbox" value="S" class="checkfiltros" id="cbConsideraEtiqueta" data-placement="top" checked><label for="cbConsideraEtiqueta" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas as etiquetas selecionados na pesquisa, se desmarcado, desconsidera as etiquetas selecionados na pesquisa e filtra por todos as outras etiquetas."></label>
                                                    <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtEtiqueta">Etiqueta: </label>
                                                </div>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtEtiqueta" name="txtEtiqueta" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-EtiquetaConsulta" name="btn-EtiquetaConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Etiqueta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtParte">Parte: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtParte" name="txtParte" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-ParteConsulta" name="btn-ParteConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Parte" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtPeriodo">Período: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtPeriodo" name="txtPeriodo" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-PeriodoConsulta" name="btn-PeriodoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-Periodo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtStatusProd">Status Prod.: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtStatusProd" name="txtStatusProd" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-StatusProdConsulta" name="btn-StatusProdConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-StatusProd" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtPrazoProd">Prazo Prod.: </label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <select class="js-example-programmatic js-states form-control" id="txtPrazoProd" name="txtPrazoProd" multiple="multiple"></select>
                                                        <div class="input-group-append">
                                                            <button class="btn bg-danger" id="btn-PrazoProdConsulta" name="btn-PrazoProdConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            <button class="btn bg-danger" id="btn-limpa-PrazoProd" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group">
                                                <label data-error="wrong" data-success="right" for="txtProdClasTipo">Tipo e classificação:</label>
                                                <div class="input-group">
                                                    <select class="js-example-programmatic js-states form-control" id="txtProdClasTipo" name="txtProdClasTipo" multiple="multiple"></select>
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnProdClasTipo" name="btnProdClasTipo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaProdClasTipo" name="btnLimpaProdClasTipo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-lg-2 col-sm-12 col-12">
                                                <div class="form" id="TipoDeOf">
                                                    <fieldset class="form border-Field">
                                                        <legend class="textoBorda mb-0 pb-0">Tipo de OF</legend>
                                                        <div class="form-row ml-auto">
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdTodos" checked name="rdfiltroTipoDeOf" value="0">
                                                                <label class="labelCheck" for="rdTodos">Todos</label>
                                                            </div>
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdOFsSimples" name="rdfiltroTipoDeOf" value="1">
                                                                <label class="labelCheck" for="rdOFsSimples">OFs Simples</label>
                                                            </div>
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdOFsNormais" name="rdfiltroTipoDeOf" value="2">
                                                                <label class="labelCheck" for="rdOFsNormais">OFs Normais</label>
                                                            </div>
                                                    </fieldset>
                                                </div>
                                            </div>
                                            <div class="col-lg-2 col-sm-12 col-12">
                                                <div class="form" id="buscarOf">
                                                    <fieldset class="form border-Field">
                                                        <legend class="textoBorda mb-0 pb-0">Buscar OF</legend>
                                                        <div class="form-row ml-auto">
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdBuscaTodos" checked name="rdfiltroBuscarOf" value="0">
                                                                <label class="labelCheck" for="rdBuscaTodos">Todos</label>
                                                            </div>
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdBuscaNormal" name="rdfiltroBuscarOf" value="1">
                                                                <label class="labelCheck" for="rdBuscaNormal">Normal</label>
                                                            </div>
                                                            <div class="icheck-primary form-group form-check col-12">
                                                                <input type="radio" id="rdBuscaReprocesso" name="rdfiltroBuscarOf" value="2">
                                                                <label class="labelCheck" for="rdBuscaReprocesso">Reprocesso</label>
                                                            </div>
                                                        </div>
                                                    </fieldset>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-sm-12 col-12">
                                                <div class="form" id="tiposOf">
                                                    <fieldset class="form border-Field">
                                                        <legend class="textoBorda mb-0 pb-0">Tipo OF</legend>
                                                        <div class="form-row ml-auto">
                                                            <div class="col-6">
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="radio" id="rdTipoTodos" checked name="rdfiltroTipoOf" value="0">
                                                                    <label class="labelCheck" for="rdTipoTodos">Todos</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="radio" id="rdTipoNormal" name="rdfiltroTipoOf" value="1">
                                                                    <label class="labelCheck" for="rdTipoNormal">Normal</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="radio" id="rdTipoAtacado" name="rdfiltroTipoOf" value="2">
                                                                    <label class="labelCheck" for="rdTipoAtacado">Atacado</label>
                                                                </div>
                                                            </div>
                                                            <div class="col-6">
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="radio" id="rdTipoVarejo" name="rdfiltroTipoOf" value="3">
                                                                    <label class="labelCheck" for="rdTipoVarejo">Varejo</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="radio" id="rdTipoECommerce" name="rdfiltroTipoOf" value="4">
                                                                    <label class="labelCheck" for="rdTipoECommerce">E-Commerce</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </fieldset>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-12 form-group mt-2">
                                                <button id="btnCarregaEmpresas" class="btn btn-danger col-lg-12 col-md-12 col-12">Selecionar Empresas</button>
                                            </div>
                                        </div>
                                        <div class="row col-12">
                                            <div class="col-lg-12 col-sm-12 col-12">
                                                <div class="form" id="TipoDeOf">
                                                    <fieldset class="form border-Field">
                                                        <legend class="textoBorda mb-0 pb-0">Opções</legend>
                                                        <div class="form-row ml-auto">
                                                            <div class="col-3">
                                                                <div class="icheck-primary form-group form-check">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbFoto">
                                                                    <label class="labelCheck" for="cbFoto"> Foto do Produto</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbDiasPendentes">
                                                                    <label class="labelCheck" for="cbDiasPendentes"> Dias Pendentes</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbAgruparPorOf">
                                                                    <label class="labelCheck" for="cbAgruparPorOf"> Agrupar Por O.F.</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbBuscarBaixados">
                                                                    <label class="labelCheck" for="cbBuscarBaixados"> Buscar Baixados</label>
                                                                </div>
                                                            </div>
                                                            <div class="col-3">
                                                                <div class="icheck-primary form-group form-check">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbSomarConjunto">
                                                                    <label class="labelCheck" for="cbSomarConjunto">Somar Conjunto</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbResumoPeriodo">
                                                                    <label class="labelCheck" for="cbResumoPeriodo"> Resumo p/ Período</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbSomarPecas">
                                                                    <label class="labelCheck" for="cbSomarPecas"> Somar Peças</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbBuscarNotasFiscais">
                                                                    <label class="labelCheck" for="cbBuscarNotasFiscais"> Buscar Notas Fiscais</label>
                                                                </div>
                                                            </div>
                                                            <div class="col-3">
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbNotasTodasEmpresas">
                                                                    <label class="labelCheck" for="cbNotasTodasEmpresas"> Notas Todas Empresas</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbBuscarPrecoSped">
                                                                    <label class="labelCheck" for="cbBuscarPrecoSped"> Buscar Preço SPED</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbMostrarProximoSetor">
                                                                    <label class="labelCheck" for="cbMostrarProximoSetor"> Mostrar Proximo Setor</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbCustoIndustrial">
                                                                    <label class="labelCheck" for="cbCustoIndustrial"> Custo Industrial</label>
                                                                </div>
                                                            </div>
                                                            <div class="col-3">
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbBuscaDataPrevSetor">
                                                                    <label class="labelCheck" for="cbBuscaDataPrevSetor"> Busca Data Prev Setor</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbConsiderarUltSetor">
                                                                    <label class="labelCheck" for="cbConsiderarUltSetor"> Considerar Ult. Setor</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbProcessoSubProduto">
                                                                    <label class="labelCheck" for="cbProcessoSubProduto"> Processo Sub-Produto</label>
                                                                </div>
                                                                <div class="icheck-primary form-group form-check col-12">
                                                                    <input type="checkbox" class="configCheckOpcoes" id="cbListaPartes">
                                                                    <label class="labelCheck" for="cbListaPartes"> Lista Partes</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </fieldset>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-start pl-0">
                        <div class="row col-12">
                            <div class="col-xl-4 col-12">
                                <label for="txtOrdem">Opção de Relatório:</label>
                                <div class="relative d-flex align-items-center">
                                    <select id="txtOrdem" class="input-default focus custom-select">
                                    </select>
                                    <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                                        <i class="fas fa-check"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-6 col-lg-8 d-flex justify-content-end align-items-end pr-0">
                                <div class="d-flex">
                                    <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222">
                                        <span class="fas fa-trash"></span> Limpar Filtros
                                    </button>
                                    <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                                        <span class="fas fa-search"></span> Consultar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside><!-- /.control-sidebar -->
        <?php include_once('../../modais.php'); ?>
    </main><!-- /.wrapper -->

    <script src="plugins/jquery/jquery.min.js?versao=3.2510.9.1"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2510.9.1"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2510.9.1"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2510.9.1"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2510.9.1"></script>
    <script src="dist/js/adminlte.min.js?versao=3.2510.9.1"></script>
    <script src="dist/js/sisplan.js?versao=3.2510.9.1"></script>
    <script src="utils/funcoes.js?versao=3.2510.9.1"></script>
    <script src="utils/cookies.js?versao=3.2510.9.1"></script>
    <script src="dist/js/requisicoes.js?versao=3.2510.9.1"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.2510.9.1"></script>
    <script src="dist/js/driver.min.js?versao=3.2510.9.1"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.2510.9.1"></script>
    <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2510.9.1"></script>
    <script type="text/javascript" src="dist/js/sum().js?versao=3.2510.9.1"></script>
    <script type="text/javascript" src="config.js?versao=3.2510.9.1"></script>
    <script type="text/javascript" src="plugins/jszip/jszip.min.js?versao=3.2510.9.1"></script>
    <script type="text/javascript" src="plugins/pdfmake/pdfmake.min.js?versao=3.2510.9.1"></script>
    <script type="text/javascript" src="plugins/pdfmake/vfs_fonts.js?versao=3.2510.9.1"></script>
    <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.2510.9.1"></script>
    <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.2510.9.1"></script>
    <script src="graficos/graficos.js?versao=3.2510.9.1"></script>
    <script src="plugins/high-charts/highcharts.js"></script>
    <script src="plugins/high-charts/highcharts-3d.js"></script>
    <script src="plugins/high-charts/cylinder.js"></script>
    <script src="plugins/high-charts/exporting.js"></script>
    <script src="plugins/high-charts/export-data.js"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('RELPENDENTE');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            sArquivo = `${BASE_URI}/pages/relpendente/relpendente.js?versao=3.2510.9.1`;
            insereJavaScriptPagina(sArquivo);

        });
    </script>
</body>

</html>