$('#tutorial').on('click', function () {
    $('#geral-tab').trigger('click');
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btn-filtros',
            popover: {
                title: 'Botão Filtrar',
                description: 'Clique aqui para abrir os campos disponíveis de filtro.',
                position: 'botton'
            }
        },
        {
            element: '#check_todosTour',
            popover: {
                title: 'Selecionar Todos',
                description: 'Aqui você seleciona todos os registros.',
                position: 'top'
            }
        },
        {
            element: '#aplicarTodosTour',
            popover: {
                title: 'Aplicar a Todos',
                description: 'Aqui você aplica as opções a todos os registros selecionados.',
                position: 'top'
            }
        },
        {
            element: '#tabelaAcessos_wrapper',
            popover: {
                title: 'Lista de Acessos',
                description: 'Aqui você encontra a lista de usuários e seus respectivos acessos.',
                position: 'top'
            }
        }, {
            element: '#btn-liberar',
            popover: {
                title: 'Botão Confirmar',
                description: 'Clicando aqui você libera ou remove os acessos dos usuários conforme manutenção feita no passo anterior.',
                position: 'top'
            }
        }
        ]);
        driver.start();
        const activeElement = driver.getHighlightedElement();
    });
});

$(document).ready(async function () {

    var tabelaAcessos = $('#tabelaAcessos').DataTable({
        paging: false,
        filter: true,
        info: false,
        order: false,
        destroy: true,
        scrollX: true,
        scrollY: '200px',
    });

    // $('#txtUsuario').autocompleta(1, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo chave", "NOME descricao"], "where": ["CODIGO <> '9999'"]}`);
    // $('#btnUsuario').pesquisa('#txtUsuario', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo", "NOME"], "where": ["CODIGO <> '9999'"]}`, 'Pesquisa Usuário', 'ACESSO_USUARIOS');
    // $('#btnAUsuario').on('click', function () {
    //     $('#txtUsuario').val('');
    // });

    const naoFiltraSisplan = getCookie('cod_usuario') != '0000' ? `AND CODIGO <> '0000'` : '';
    componenteFiltro('usuario2', true, false, '', [`CODIGO <> '9999' ${naoFiltraSisplan}`]);

    const tabelaTratada = 'Tela';
    const input = $(`#txt${tabelaTratada}`);
    const botao = $(`#btn${tabelaTratada}`);
    const botaoLimpar = $(`#btnLimpa${tabelaTratada}`);

    if (!input[0] || !botao[0] || !botaoLimpar[0]) {
        throw new Error('algum dos componentes está errado');
    }

    $(input).pesquisa_variosServerside(1, '{}', 'TELA', 'TELA');
    $(botao).pesquisa_serversideSel(input, `{}`, `Pesquisa de Tela`);

    $(input).addClass('camposFiltros');

    $(botaoLimpar).on('click', function () {
        $(input).empty().trigger('change');
        $(input).val('');
        $(input).attr('data-chave', '');
        $(input).attr('data-desc', '');
    });

    $('#txtCopia').autocompleta(1, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo chave", "NOME descricao"], "where": ["CODIGO <> '9999'"]}`);
    $('#btnCopia').pesquisa('#txtCopia', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo", "NOME"], "where": ["CODIGO <> '9999'"]}`, 'Pesquisa Usuário', 'ACESSO_USUARIOS');
    $('#btnACopia').on('click', function () {
        $('#txtCopia').val('');
    });

    $('#txtCopiaPara').autocompleta(1, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo chave", "NOME descricao"], "where": ["CODIGO <> '9999'"]}`);
    $('#btnCopiaPara').pesquisa('#txtCopiaPara', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo", "NOME"], "where": ["CODIGO <> '9999'"]}`, 'Pesquisa Usuário', 'ACESSO_USUARIOS');
    $('#btnACopiaPara').on('click', function () {
        $('#txtCopiaPara').val('');
    });

    async function buscarDados() {
        var _url = `/Sisplan/permissaotela/v1/permissao?`;
        try {
            $.LoadingOverlay("show");
            const telas = await formataListas($('#txtTela').val().toString());
            const usuarios = await formataListas($('#txtUsuario2').val().toString());
            var response = await requisicao('GET', _url, `codusuario=${usuarios}&tela=${telas}&EMP_ID=${getCookie('emp_id')}`, null, 60000);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            var jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr['RESULT'][0].mensagem);
                return;
            }
            $.LoadingOverlay("hide");
            return jsonStr;
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgErro('Não foi possível buscar os dados de acesso.');
        }
    };

    $('#btn-confirmar-copia').on('click', async function () {
        const usrCopia = pegaChave('#txtCopia');
        const usr = pegaChave('#txtCopiaPara');

        if ((usr == '') || (usrCopia == '')) {
            msgAlerta('Necessário preencher os dois campos para copiar os acessos.');
            return;
        };

        msgAlerta(`Tem certeza que deseja copiar as permissões?`, async () => {
            const url = `/Sisplan/permissaotela/v1/copiar?`;
            try {
                const response = await requisicao("POST", url, `USUARIO_DE=${usrCopia}&USUARIO_PARA=${usr}`, "", 300000);

                if (!response) {
                    throw msgAlerta("Não foi possível copiar as permissões.");
                }

                if (response.status != 200) {
                    throw msgAlerta("Não foi possível copiar as permissões.");
                }

                criaMensagemSucesso("Permissões copiadas com sucesso", async () => {
                    $('#modal-copiar-acessos').modal('hide');
                });

            } catch (error) {
                console.error(error);
            }
        });
    });

    async function salvarDados() {
        var _url = `/Sisplan/permissaotela/v1/permissao?`;
        var arraypermissao = [];
        try {
            $.LoadingOverlay("show");
            for (let i = 0; i < $('#tabelaAcessos').DataTable().rows().count(); i++) {
                if ($('#check_col_' + i + '_row_0').prop('checked')) {
                    var dados = $('#tabelaAcessos').DataTable().row(i).data();
                    var permissao = new Object();
                    permissao.USUARIO = dados.USUARIO;
                    permissao.NOME = dados.NOME;
                    permissao.TELA = dados.TELA;
                    permissao.ACAO = dados.ACAO;
                    permissao.PERMISSAO = $('#check_col_' + i + '_row_5').prop('checked') ? 'S' : 'N';
                    permissao.EMP_ID = getCookie('emp_id');
                    arraypermissao.push(permissao);
                }
            }

            var response = await requisicao('POST', _url, '', `JSON=${encodeURIComponent(JSON.stringify(arraypermissao))}`, 60000)

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            var jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr['RESULT'][0].mensagem);
                return;
            }
            toastr.success(
                'Liberação efetuada com sucesso!',
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden: function () {
                    window.location.href = `${BASE_URI}/permissoes_tela`;
                }
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });;
            $.LoadingOverlay("hide");
            return jsonStr;
        } catch (error) {
            $.LoadingOverlay("hide");
            msgErro('Não foi possível buscar os dados de acesso.');
        }
    };


    $('#check_todos').on('change', function () {

        $('.campoSel').prop('checked', $('#check_todos').prop('checked'));
    });

    $('#check_permissao').on('change', function () {
        for (let i = 0; i < $('.campoSel').length; i++) {
            if ($($('.campoSel')[i]).prop('checked')) {
                $($('.campoAltera')[i]).prop('checked', $('#check_permissao').prop('checked'));
            }
        }
    });

    $('#btn-liberar').on('click', async function () {
        salvarDados();
    });

    $('#btn-consultar').on('click', async function () {

        var dados = await buscarDados();
        var dataSetCols = [];

        if (dados.length > 0) {
            var keys = Object.keys(dados[0]);
            dataSetCols.push({
                'title': 'SEL',
                'data': 'SEL',
                'width': '15px'
            });
        } else {
            $('#tabelaAcessos').DataTable().clear().draw(false)
            msgAlerta('Nenhum registro econtrado!');
            return;
        }

        dataSetCols[0].render = function (data, type, row, meta) {
            return `<div class="icheck-primary d-inline">
                        <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
                        <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`
        }

        for (var k in keys) {
            dataSetCols.push({
                'data': keys[k]
            });
        }

        dataSetCols[5].render = function (data, type, row, meta) {
            return `<div class="icheck-danger d-inline">
                        <input type="checkbox" ${row.PERMISSAO == 'S' ? 'checked' : ''} id="check_col_${meta.row}_row_${meta.col}" class="campoAltera">
                        <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`
        }

        tabelaAcessos = $('#tabelaAcessos').DataTable({
            paging: false,
            filter: true,
            info: true,
            order: true,
            destroy: true,
            scrollX: true,
            scrollY: '500px',
            "data": dados,
            "columns": dataSetCols
        });

        $('#modal-filtros').modal('hide');

        $('.campoSel').on('change', function () {
            if (this.checked) {
                $(this).addClass('selecionado');
            } else {
                $(this).removeClass('selecionado');
            }
        });

    });

    // $('#btn-consultar').trigger('click');

});