$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código',
                description: 'Aqui, adicionamos o código da sub característica.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Aqui, adicionamos a descrição da sub característica.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a sub característica.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {


    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let subCaracteristica = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('SUBCARACTERISTICA', getCookie('usuario'), subCaracteristica);
        window.location.href = `${BASE_URI}/subcaracteristica`;
    });

    componenteFiltro('setor', false, false)

    $('#txtTempo').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtCodigo').on('blur', async function () {
        if ($(this).val() != '') {
            return
        }
        $.LoadingOverlay('show')
        try {
            const newCodigo = await RetornaProximo('CODIGO', 'CARACTERISTICA', 'CODIGO', 3)

            $(this).val(newCodigo)
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    if (subCaracteristica != '' && subCaracteristica != 'create') {

        if (await liberarRegistro('SUBCARACTERISTICA', subCaracteristica) == false) {
            window.location.href = '../subcaracteristica';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"CARACTERISTICA", 
                    "camposSelect":["CODIGO", "DESCRICAO","SETOR","TEMPO", "ATIVO","COMPLEXIDADE"], 
                    "where": ["CODIGO = '${subCaracteristica}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                    $('#txtSetor').val(jsonStr.RESULT[0][0].SETOR);
                    insereValor('#txtSetor', jsonStr.RESULT[0][0].SETOR, { tabela: 'CADFLUXO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: jsonStr.RESULT[0][0].SETOR });
                    $('#txtTempo').val(jsonStr.RESULT[0][0].TEMPO);
                    if (jsonStr.RESULT[0][0].ATIVO == 'N') {
                        $('#cbAtivo').prop('checked', false);
                    }

                    if (jsonStr.RESULT[0][0].COMPLEXIDADE == '0') {
                        $('#radioFacil').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].COMPLEXIDADE == '1') {
                        $('#radioMedio').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].COMPLEXIDADE == '2') {
                        $('#radioDificil').prop('checked', true);
                    }

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da sub característica: ${error}`);
                }
            } finally {
                $('#txtCodigo').attr('readonly', true);
                $.LoadingOverlay('hide');
            }
        }
    }

    $("#gravar").click(

        async function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();
            if (!$('#txtCodigo').val()) {
                throw msgAlerta('Nenhum código inserido, favor verificar.')
            }
            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    classe = {};

                    classe.CODIGO = $('#txtCodigo').val()
                    classe.DESCRICAO = $('#txtDescricao').val().toUpperCase();
                    classe.SETOR = pegaChave('#txtSetor');
                    classe.TEMPO = $('#txtTempo').val();

                    classe.ATIVO = $('#cbAtivo').is(':checked') ? 'S' : 'N';
                    if ($('#radioFacil').is(':checked')) {
                        classe.COMPLEXIDADE = 0
                    }
                    if ($('#radioMedio').is(':checked')) {
                        classe.COMPLEXIDADE = 1
                    }
                    if ($('#radioDificil').is(':checked')) {
                        classe.COMPLEXIDADE = 2
                    }

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/subcaracteristica?', `JSON=${encodeURIComponent(JSON.stringify(classe))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/subcaracteristica`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                }
            }
        });
});