$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Código",
          description:
            "O campo de código é preenchido automaticamente após gravar o registro.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Neste campo adicionamos a descrição para o tipo de contato.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o preço.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtCodigo: {
        required: true,
      },
      txtDescricao: {
        required: true,
      },
    },
    messages: {
      txtCodigo: {
        required: "Informe um código válido.",
      },
      txtDescricao: {
        required: "Informe uma descrição válida.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $("#btnVoltar").on("click", async function () {
    window.location.href = `${BASE_URI}/tipocontato`;
  });

  const tipo = $(window.location.href.split('/')).get(-1);

  carregaDados(tipo);

  async function carregaDados(tipoBusca) {
    if (tipo == 'create') {
      return;
    }
    $.LoadingOverlay("show");
    try {
      const pesquisaParam = {
        tabela: 'TIPO_CONTATO',
        camposSelect: ['CODIGO', 'DESCRICAO', 'TIPO'],
        where: [`CODIGO = '${tipoBusca}'`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      insereValor('#txtCodigo', tipoBusca);
      insereValor('#txtDescricao', jsonStr[0].DESCRICAO);

      $('#radioOrigem').prop('checked', jsonStr[0].TIPO == 'O');
      $('#radioTipo').prop('checked', jsonStr[0].TIPO == 'T');
      $('#radioForma').prop('checked', jsonStr[0].TIPO == 'F');
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#btnGravar').click(async function () {
    const validator = $('#msform').validate();
    validator.form();
    const erros = validator.numberOfInvalids();

    if (erros != 0) {
      return;
    }

    $.LoadingOverlay('show');
    try {

      const tipo = {};

      tipo.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('TIPO_CONTATO', 'TIPO_CONTATO', 'CODIGO', 3) : $('#txtCodigo').val();
      tipo.DESCRICAO = $('#txtDescricao').val();
      tipo.TIPO = $('#radioOrigem').is(':checked') ? 'O' : ($('#radioTipo').is(':checked') ? 'T' : 'F');

      const response = await requisicao('POST', '/sisplan/cadastros/v1/tipocontato?', `JSON=${encodeURIComponent(JSON.stringify(tipo))}`, null);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay('hide');

      criaMensagemSucesso('Cadastro efetuado com sucesso!', () => { window.location.href = `${BASE_URI}/tipocontato` })

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
      msgErro(error);
    }
  });

});
